#include "los_process_pri.h"
#include "los_printf.h"

// STATIC UINT8 *ConvertTaskStatusToString(UINT16 taskStatus)
// {
//     if (taskStatus & OS_TASK_STATUS_INIT) {
//         return (UINT8 *)"Init";
//     } else if (taskStatus & OS_TASK_STATUS_RUNNING) {
//         return (UINT8 *)"Running";
//     } else if (taskStatus & OS_TASK_STATUS_READY) {
//         return (UINT8 *)"Ready";
//     } else if (taskStatus & OS_TASK_STATUS_FROZEN) {
//         return (UINT8 *)"Frozen";
//     } else if (taskStatus & OS_TASK_STATUS_SUSPENDED) {
//         return (UINT8 *)"Suspended";
//     } else if (taskStatus & OS_TASK_STATUS_DELAY) {
//         return (UINT8 *)"Delay";
//     } else if (taskStatus & OS_TASK_STATUS_PEND_TIME) {
//         return (UINT8 *)"PendTime";
//     } else if (taskStatus & OS_TASK_STATUS_PENDING) {
//         return (UINT8 *)"Pending";
//     } else if (taskStatus & OS_TASK_STATUS_EXIT) {
//         return (UINT8 *)"Exit";
//     }

//     return (UINT8 *)"Invalid";
// }

STATIC UINT8 *ConvertProcessModeToString(UINT16 mode)
{
    if (mode == OS_KERNEL_MODE) {
        return (UINT8 *)"kernel";
    } else if (mode == OS_USER_MODE) {
        return (UINT8 *)"user";
    }

    return (UINT8 *)"ERROR";
}

// STATIC UINT8 *ConvertSchedPolicyToString(UINT16 policy)
// {
//     if (policy == LOS_SCHED_RR) {
//         return (UINT8 *)"RR";
//     } else if (policy == LOS_SCHED_FIFO) {
//         return (UINT8 *)"FIFO";
//     } else if (policy == LOS_SCHED_DEADLINE) {
//         return (UINT8 *)"EDF";
//     } else if (policy == LOS_SCHED_IDLE) {
//         return (UINT8 *)"IDLE";
//     }

//     return (UINT8 *)"ERROR";
// }

STATIC UINT8 *ConvertProcessStatusToString(UINT16 status)
{
    if (status & OS_PROCESS_STATUS_ZOMBIES) {
        return (UINT8 *)"Zombies";
    } else if (status & OS_PROCESS_STATUS_INIT) {
        return (UINT8 *)"Init";
    } else if (status & OS_PROCESS_STATUS_RUNNING) {
        return (UINT8 *)"Running";
    } else if (status & OS_PROCESS_STATUS_READY) {
        return (UINT8 *)"Ready";
    } else if (status & OS_PROCESS_STATUS_INACTIVE) {
        return (UINT8 *)"Inactive";
    }
    return (UINT8 *)"Pending";
}

UINT16 GetProcessPriority(LosProcessCB* processCB) {
    LosTaskCB* taskGroup = processCB->threadGroup;
    SchedParam param = {0};
    taskGroup->ops->schedParamGet(taskGroup, &param);
    switch (param.policy)
    {
    case LOS_SCHED_DEADLINE:
        return 32;
        break;
    default:
        return param.basePrio;
        break;
    }
}

void SysPrintTaskinfo(void) {
    LosProcessCB* processCB;
    PRINTK("Kernel mode: SYS_print_taskinfo\n");
    PRINTK("\r\n  PID  PPID PGID     Mode  Status Priority PName\n");
    for(int index=0; index < g_processMaxNum; index++) {
        processCB = OS_PCB_FROM_RPID(index);
        if(processCB->processStatus & OS_PROCESS_FLAG_UNUSED) continue;

        PRINTK(" %4u", processCB->processID);
        if(processCB->parentProcess)
            PRINTK("%6u", processCB->parentProcess->processID);
        else
            PRINTK("%6d", -1);
        PRINTK("%5u", OS_GET_PGROUP_LEADER(processCB->pgroup)->processID);
        PRINTK("%9s%8s%9u", ConvertProcessModeToString(processCB->processMode), ConvertProcessStatusToString(processCB->processStatus), GetProcessPriority(processCB));
        PRINTK("  %-32s\n", processCB->processName);
    }
    return;
}